package sk.inlogic.oldskoolracing;

import java.util.Vector;

import android.util.Log;
import simple.debug.DebugOutput;
import simple.input.Keys;
import simple.video.Graphics;
import simple.video.Image;


public class ScreenSplash implements IScreen, IMenuItemActivator, IMenuItemRenderer
{
	// definicia modov pre dany screen
	final int MODE_VOID 		= 0;
	final int MODE_LOADINGRES 	= 1;
	final int MODE_LANGUAGES 	= 2;
	final int MODE_SOUNDS 		= 3;
	final int MODE_LOGO 		= 4;
	final int MODE_TITLE 		= 5;
		
	// cas v ms kolko caka pri danom mode
	final int TIME_DELAY 		= 3000;
	
	int iMode;
	int iModeDelay;
	
	MyApplication pMyApplication;	
	MenuSystem pMenuSystem;
	
	public ScreenSplash()
	{
		pMyApplication = MyApplication.getInstance();
		iMode = MODE_LOADINGRES;	
	}
	
	private void prepareEnableSounds()
	{
		Resources.prepareMultiLineText(Texts.getString(Texts.ID_ENABLE_SOUNDS));
	}
	
	public void update(long lTick)
	{		
		if(iMode > MODE_SOUNDS)
			if(iModeDelay > 0){
				iModeDelay -= lTick;
				if(iModeDelay <= 0)
					nextMode();
			}/*	*/	
		
		pMyApplication.repaintScreen();

		if(iMode == MODE_LOADINGRES)
			updateModeLoadingRes();
	}
	
	private void updateModeLoadingRes()
	{
		//pMyApplication.repaintScreen();
		
		Resources.loadInitialResources();
		
		pMenuSystem = MenuSystem.getInstance();
		pMenuSystem.setMenuItemActivator(this);
		pMenuSystem.setMenuItemRenderer(this);
		pMenuSystem.reset();
		
		int iGap = Resources.iLangW / 5;			
		int iWidth = Resources.iLangW;
		int iHeight = Resources.iLangH; 
		int iPosX = (Resources.iScreenW - iWidth) / 2;
		int iPosY = iHeight / 2 + (Resources.iScreenH - (iHeight + iGap)) / 2;
		
		
		pMenuSystem.addMenuItem(new CMenuItem(0,"ENGLISH", iPosX - iWidth - iGap, iPosY, iWidth, iHeight));
		pMenuSystem.addMenuItem(new CMenuItem(1,"FRANÇAIS", iPosX, iPosY, iWidth, iHeight));
		pMenuSystem.addMenuItem(new CMenuItem(2,"DEUTSCH", iPosX + iWidth + iGap, iPosY, iWidth, iHeight)); 
		
		pMenuSystem.addMenuItem(new CMenuItem(3,"ITALIANO", iPosX - iWidth - iGap, iPosY + iHeight + iGap, iWidth, iHeight));
		pMenuSystem.addMenuItem(new CMenuItem(4,"ESPAÑOL", iPosX, iPosY + iHeight + iGap, iWidth, iHeight)); 
		pMenuSystem.addMenuItem(new CMenuItem(5,"PORTUGUÊS", iPosX + iWidth + iGap, iPosY + iHeight + iGap, iWidth, iHeight));
		
		pMenuSystem.iMenuType = pMenuSystem.TYPE_LANG;
		
		iMode = MODE_LANGUAGES;	
		Resources.loadLangResources();
		
		pMyApplication.repaintScreen();
		
		
	}

	public void paintScreen(Graphics g)
	{
		switch(iMode)
		{
		case MODE_LANGUAGES:
			paintModeLanguage(g);
			break;
		case MODE_SOUNDS:
			paintModeSounds(g);
			break;
		case MODE_LOGO:
			paintModeLogo(g);
			break;
		case MODE_TITLE:
			paintModeTitle(g);
			break;
		}
		
	}

	private void paintModeLanguage(Graphics g){
		g.setColor(0x000000);
		g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
		
		pMenuSystem.paintMenu(g);
	}
	
	public void renderMenuItem(Graphics g, CMenuItem pMenuItem, boolean bSelected)
	{	
		int iTextW = Texts.getTextWidth(pMenuItem.getCaption());
		int iDspX = (pMenuItem.getWidth() - iTextW) / 2;
		
		if(bSelected){
			Resources.sprLangOn.setFrame(pMenuItem.getID());
			Resources.sprLangOn.setPosition(pMenuItem.getLeft(), pMenuItem.getTop());
			Resources.sprLangOn.paint(g);	
		}else{
			Resources.sprLang.setFrame(pMenuItem.getID());
			Resources.sprLang.setPosition(pMenuItem.getLeft(), pMenuItem.getTop());
			Resources.sprLang.paint(g);
		}
		
		int partsY = Resources.iScreenH / Resources.iBorderH - 2;
		int iPosY = (Resources.iScreenH - Resources.iBorderH * partsY ) / 2 +(partsY)* Resources.iBorderH - Texts.getFontHeight() - Texts.getFontHeight()/2;
		if(bSelected)
			Texts.drawTextAtPos(g,(Resources.iScreenW - iTextW )/2,iPosY , pMenuItem.getCaption());/**/
	}
	
	private void paintModeSounds(Graphics g)
	{
		int partsX = Resources.iScreenW / Resources.iBorderW - 2;
		int partsY = Resources.iScreenH / Resources.iBorderH - 2;
		Resources.paintMenuBG(partsX, partsY, g);
		
		
		int iPosY = (Resources.iScreenH - Resources.iBorderH *( partsY - 1)) / 2;
		Resources.imgLogo.drawAtPoint(g, (Resources.iScreenW - Resources.iLogoW)/2, iPosY);
		
		int y = ((partsY * Resources.iBorderH - Resources.iLogoH) - Resources.iMenuIcOutH ) / 2 + iPosY/2 + Resources.iLogoH;
		
		Resources.sprMenuIcs.setFrame(0);
		Resources.sprMenuIcs.setPosition((Resources.iScreenW - Resources.iMenuIcsW)/2, y + Resources.MENU_RING_OFFSET);
		Resources.sprMenuIcs.paint(g);
		
		Resources.imgMenuIcOut.drawAtPoint(g, (Resources.iScreenW - Resources.iMenuIcOutW)/2, y);
		
		Resources.paintLeftButton(g, partsY);
		Resources.paintRightButton(g, partsY);
	}

	private void paintModeLogo(Graphics g)
	{
		g.setColor(0xFF0000);
		g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
		Resources.imgBackground = Resources.createImage("/minl.png");
		Resources.paintBackground(g);
	}

	private void paintModeTitle(Graphics g)
	{
		g.setColor(0xFF0000);
		g.fillRect(0, 0, Resources.iScreenW, Resources.iScreenH);
		Resources.imgBackground = Resources.createImage("/mspl.png");
		Resources.paintBackground(g);
	}

	public void keyPressed(simple.input.Key pKey)
	{
		switch(iMode){
		case MODE_LANGUAGES:
			keyPressedModeLanguages(pKey);
			break;
		case MODE_SOUNDS:
			keyPressedModeSounds(pKey);
			break;
		case MODE_LOGO:
		case MODE_TITLE:			
			keyPressedModeSplash(pKey);
			break;
		}
	}

	private void keyPressedModeLanguages(simple.input.Key pKey)
	{
		pMenuSystem.keyPressed(pKey);

		if(pKey.iGameAction == Keys.KEY_FIRE){
			pMenuSystem.activateSelectedMenuItem();
			nextMode();
		}
	}
	
	void keyPressedModeSounds(simple.input.Key pKey)
	{				
		if(pKey.iValue == Keys.KEY_FNLEFT){
			Profile.bMusic = true;
			nextMode();
			return;
		}
		//FIRE, FN_RIGHT
		if((pKey.iValue == Keys.KEY_FNRIGHT) || (pKey.iGameAction == Keys.KEY_FIRE) || (pKey.iValue == Keys.KEY_NUM5)){
			Profile.bMusic = false;
			nextMode();		
		}
	}

	void keyPressedModeSplash(simple.input.Key pKey)
	{
		if((pKey.iGameAction == Keys.KEY_FIRE) || (pKey.iValue == Keys.KEY_NUM5)  || (pKey.iValue == 'd'))
			nextMode();			
	}
		
	// toto vola dalsie screeny 
	void nextMode()
	{
		iModeDelay = TIME_DELAY;
		
		switch(iMode){
		case MODE_LANGUAGES:
			Resources.loadSplashResources();
			//prepareEnableSounds();
			iMode = MODE_SOUNDS;
			break;
		case MODE_SOUNDS:
			iMode = MODE_LOGO;
			break;
		case MODE_LOGO:
			iMode = MODE_TITLE;
			break;
		case MODE_TITLE:
			Resources.releaseSplashResources();
			
			MyApplication.pScrMenu = new ScreenMenu();
			MyApplication.pActiveScreen = MyApplication.pScrMenu;			
			MyApplication.pScrSplash = null;
			//System.gc();
			
			iMode = MODE_VOID;
			break;
		}
	}
	
	public void keyReleased(simple.input.Key pKey)
	{
	}
	
	//#ifndef NO_TOUCH
	public void pointerPressed(int x, int y)
	{
		if(iMode == MODE_SOUNDS){
			if(Resources.pressedLeftButton(x, y)){
				Profile.bMusic = true;
				nextMode();	
				return;
			}	
			if(Resources.pressedRightButton(x, y)){
				Profile.bMusic = false;
				nextMode();	
				return;
			}	
		}

		Log.d("pointer pressed", x+", "+y);
		
		pMenuSystem.pointerPressed(x, y);
	}

	public void pointerReleased(int x, int y)
	{
	}
	//#endif

	public void onMenuItemActivated(int iIdx)
	{
		if(iMode == MODE_LANGUAGES)
			Texts.iLanguage = iIdx;
		
		//nextMode();		
	}

	@Override
	public void pointerDragged(int x, int y) {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onPause() {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void onResume() {
		// TODO Auto-generated method stub
		
	}

	
}
